/*=========================================================
	
	inimgr.h
	
	INI}l[WB
	
	R[obN֐Œ჌x삪łCB
	ۓIɂB
	
	R[obÑTtBbNXB
	
=========================================================*/
#ifndef INIMGR_H
#define INIMGR_H

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "psp/dmem.h"
#include "psp/fiomgr.h"
#include "utils/strutil.h"
#include "cgerrs.h"

#ifdef PSP_USE_KERNEL_LIBC
#include "psp/sysclib/sysclib.h"
#endif
	
/*-----------------------------------------------
	萔
-----------------------------------------------*/
#define INIMGR_SECTION_BUFFER  64
#define INIMGR_ENTRY_BUFFER   255

#define INIMGR_ERROR_INVALID_SIGNATURE -1
#define INIMGR_ERROR_INVALID_VERSION   -2

#ifdef __cplusplus
extern "C" {
#endif

/*-----------------------------------------------
	^錾
-----------------------------------------------*/
typedef uintptr_t IniUID;

typedef enum {
	INIMGR_CB_LOAD = 0,
	INIMGR_CB_SAVE
} InimgrCallbackMode;

struct inimgr_callback_info {
	char *section;
	SceOff offset;
	unsigned int length;
	struct inimgr_callback_info *next;
};

struct inimgr_callback {
	char *section;
	int cmplen;
	void *cb;
	void *arg;
	struct inimgr_callback_info *infoList;
	struct inimgr_callback *next;
};

struct inimgr_entry {
	char   *key;
	char   *value;
	size_t vspace;
	struct inimgr_entry *prev, *next;
};

struct inimgr_section {
	char   *name;
	struct inimgr_entry *entry;
	struct inimgr_section *prev, *next;
};

struct inimgr_params {
	DmemUID dmem;
	struct inimgr_callback *callbacks; /* R[obNݒ */
	struct inimgr_section  *index;     /* ZNṼNXg */
	struct inimgr_section  *last;      /* ɏI[̃ZNVw */
};
	
typedef struct {
	IniUID uid;
	FiomgrHandle ini;
	struct inimgr_callback_info *cbinfo;
} InimgrCallbackParams;

typedef int ( *InimgrCallback )( InimgrCallbackMode, InimgrCallbackParams*, char*, size_t, void* );

/*-----------------------------------------------
	֐vg^Cv
-----------------------------------------------*/

/*
	INI}l[WAINInh𓾂
	
	@return IniUID
		>= 0: LINInh
		< 0 : s
*/
IniUID inimgrNew( void );

/*
	ʏINIt@Cɑ݂Ȃg@\B
	ɂAkey = paramƂ`ȊÕf[^A
	INI}l[Wʂڃt@CǂŃf[^ǂނƂŏȃɂłB
	
	̃ZNV֋XR[obNZNVƌĂԁB
	
	ɏoZNV܂ł̑SẴf[^INI}l[W̎𗣂邽߁A
	INIt@CɑSقȂtH[}bg̃f[^𓂓˂ɏo邱ƂłĂ܂ƂA
	ZNVƂɂݒłȂ߁AZNVׂĂ܂ꍇȂǂ̃fbgB
	
	inimgrLoad()/inimgrSave()ɂINIt@C̓ǂݍ/ۑɁA
	R[obN֐ĂяoZNVw肷B
	
	inimgrSave()́Aɂݒ肳ꂽZNV̋L^Jn鎞ɁAR[obN֐ĂяoB
	R[obN֐inimgrMakeEntry()inimgrWriteln()ȂǂgĐݒloB
	inimgrSave()ĂяoꂽR[obN֐ł́AinimgrCbSeek*()gĂ͂ȂB
	
	inimgrLoad()́Aɂݒ肳ꂽZNVTĂƁÄʒuL^B
	̌AxINIt@CSēǂݏoAR[obN֐ĂяoB
	]āAR[obN֐AINIt@C̑̐ݒlĂяoƂ͉\B
	ÃR[obNZNV͔ɏ邽߁Aǂ߂邩ǂ̓t@C̓eɂB
	R[obN֐inimgrReadln()inimgrParseEntry()gĕKvȏ𒊏oB
	
	܂AΏۂƂȂZNVɂ́A"*"ƂTtBbNX邱ƂłB
	ƁAw肳ꂽZNV̓ZNṼvtBbNXƂĈB
	 "MySection*" ƂZNVw肵ƂƁA"MySection" ƂŎn܂ZNVA
	Ƃ΁A
	    MySection
	    MySection1
	    MySectionA
	    MySectionHoge
	    MySectionFoobar
	    MySection...
	Ȃǂ́Aݒ肵R[obN֐Ă΂B
	
	ꌩChJ[ĥ悤Ɍ邪A``ChJ[hł͂Ȃ''B
	܂ŃTtBbNXłA"*MySection"  "My*Section" ̂悤Ȏw͂łȂB
	
	܂A"*"Ƃ1ZNVƂĎw肷ƑSẴZNVœR[obN֐Ă΂邱ƂłB
	AINI}l[W̓R[obN֐̐ݒ𒲂ׂƂAݒ肳ꂽɈvZNVTA
	ŏɌR[obN֐sĎ̃ZNVɐڂB
	
	āAR[obN֐̐ݒ菇œ삪ȉ̂悤ɈقȂB
	    "MySection" ɃR[obN֐AݒA"*" ɃR[obN֐Bݒ -> "MySection" ł͊֐AsAȊOł͊֐BsB
	    "*" ɃR[obN֐YݒA"MySection" ɃR[obN֐Zݒ -> "MySection" ܂ށASẴZNVŊ֐Ŷ݂sB
	
	@param IniUID uid
		INInhB
	
	@param const char *section
		R[obN֐Ɗ֘AtZNVB
	
	@param InimgrCallback cb
		R[obN֐B
	
	@param void *arg
		R[obN֐ɓnB
	
	@return int
		0  : 
		< 0: s
*/
int inimgrSetCallback( IniUID uid, const char *section, InimgrCallback cb, void *arg );

/*
	INIt@Cǂݍ݁AݒeɎ荞ށB
	ݒeȏꍇAq[vHԂ̂ŒӁB
	
	@param IniUID uid
		INInhB
	
	@param const char *inipath
		ǂݍINIt@C̃pXB
	
	@param const char *sig
		`FbNVOl`B
		󔒕܂ނƂ͂łȂB
		vȂꍇ͓ǂݍ݂𒆒fB
		NULLŃVOl`Ao[WƂɃ`FbNȂB
	
	@param unsigned char major
		`FbN郁W[o[WԍB
		VOl`̃`FbNʉ߂Ă画肳B
		̔ԍɖȂꍇ͓ǂݍ݂𒆒fB
		
		㑱̓̔ԍāASĂ0w肳ƃo[W`FbNȂB
	
	@param unsigned char minor
		`FbN}Ci[o[WԍB
		W[o[Wԍ̃`FbNʉ߂Ă画肳B
		̔ԍɖȂꍇ͓ǂݍ݂𒆒fB
	
	@param unsigned char rev
		`FbN郊rWԍB
		}Ci[o[Wԍ̃`FbNʉ߂Ă画肳B
		̔ԍɖȂꍇ͓ǂݍ݂𒆒fB
	
	@return int
		0  : 
		< 0: s
		-1 : vȂVOl`
		-2 : sȃo[W
*/
int inimgrLoad( IniUID uid, const char *inipath, const char *sig, unsigned char major, unsigned char minor, unsigned char rev );

/*
	INIt@C֏oB
	
	@param IniUID uid
		INInhB
	
	@param const char *inipath
		ݐINIt@C̃pXB
		łɑ݂t@CłΏ㏑A݂Ȃ΍쐬B
	
	@param const char *sig
		VOl`B
		󔒕܂ނƂ͂łȂB
		NULLŃVOl`ƃo[WL^ȂB
	
	@param unsigned char major
		W[o[WԍB
		
		㑱̓̔ԍāASĂ0w肳ƃo[WL^ȂB
	
	@param unsigned char minor
		}Ci[o[WԍB
	
	@param unsigned char rev
		rWԍB
	
	@return int
		0  : 
		< 0: s
*/
int inimgrSave( IniUID uid, const char *inipath, const char *sig, unsigned char major, unsigned char minor, unsigned char rev );

/*
	INInhƂɑΉINIjB
	ΏۂINInh͖ɂȂ邽߁AgĂ͂ȂB
	
	@param IniUID uid
		INInhB
*/
void inimgrDestroy( IniUID uid );

/*
	݂INIɐVZNVǉ/폜B
	ZNV͑啶ƏʂȂB
	
	܂ "__default"ƂZNV͗\񂳂Ă邽ߎgpł܂B
	
	@param IniUID uid
		INInhB
	
	@param const char *section
		ZNVB
	
	@return int
		0  : 
		< 0: s
*/
int inimgrAddSection( IniUID uid, const char *section );
void inimgrDeleteSection( IniUID uid, const char *section );
bool inimgrExistSection( IniUID uid, const char *section );

/*
	INI񂩂w肳ꂽZNVɂw肳ꂽL[A
	Ɋ֘AÂĂl擾B
	
	ZNVA邢̓L[݂Ȃꍇ͋UԂAl̃Zbg͍sȂB
	ZNVNULLnƁAftHgZNVw肳ꂽ̂ƌȂB
	
	@param IniUID uid
		INInhB
	
	@param const char *section
		Ώۂ̃ZNVB
	
	@param const char *key
		Ώۂ̃L[B
	
	@param int *var
		Ώۂ̒lZbgϐ̃|C^B
	
	@return bool
		Ώۂꍇɐ^AłȂ΋UB
*/	
bool inimgrGetInt( IniUID uid, const char *section, const char *key, int *var );

/*
	INI񂩂w肳ꂽZNVɂw肳ꂽL[A
	Ɋ֘AÂĂl𕶎ƂĎw肳ꂽobt@ɃRs[B
	
	ZNVA邢̓L[݂Ȃꍇ-1ԂAl̃Zbg͍sȂB
	ZNVNULLnƁAftHgZNVw肳ꂽ̂ƌȂB
	
	@param IniUID uid
		INInhB
	
	@param const char *section
		Ώۂ̃ZNVB
	
	@param const char *key
		Ώۂ̃L[B
	
	@param char *buf
		Ώۂ̕Rs[obt@B
	
	@param size_t bufsize
		L̃obt@̃TCYB
	
	@return unsigned int
		obt@ɃRs[ꂽoCgB
*/
int inimgrGetString( IniUID uid, const char *section, const char *key, char *buf, size_t bufsize );

/*
	INI񂩂w肳ꂽZNVɂw肳ꂽL[A
	Ɋ֘AÂĂl𕶎ƂĈA
	ONƓtrueAOFFƓfalseԂB
	
	ON/OFF͑啶ƏʂȂB
	
	ZNVA邢̓L[݂ȂA܂͒lON/OFF̂łȂꍇ͋UԂAl̃Zbg͍sȂB
	ZNVNULLnƁAftHgZNVw肳ꂽ̂ƌȂB
	
	@param IniUID uid
		INInhB
	
	@param const char *section
		Ώۂ̃ZNVB
	
	@param const char *key
		Ώۂ̃L[B
	
	@param const bool *var
		Ώۂ̒lZbgϐ̃|C^B
	
	@return bool
		Ώۂꍇɐ^AłȂ΋UB
*/	
bool inimgrGetBool( IniUID uid, const char *section, const char *key, bool *var );

/*
	inimgrSetInt
	inimgrSetString
	inimgrSetBool
	
	ZNVɑ΂ăL[ݒ肷B
	łɑ݂ꍇ̓L[̒lXVB
	
	L[͑啶ƏʂȂB
	ZNVNULLnƁAftHgZNVw肳ꂽ̂ƌȂB
*/
int inimgrSetInt( IniUID uid, const char *section, const char *key, const long num );
int inimgrSetString( IniUID uid, const char *section, const char *key, const char *str );
int inimgrSetBool( IniUID uid, const char *section, const char *key, const bool on );

inline IniUID inimgrCbGetIniHandle( InimgrCallbackParams *params );
int inimgrCbReadln( InimgrCallbackParams *params, char *buf, size_t buflen );
int inimgrCbSeekSet( InimgrCallbackParams *params, SceOff offset );
int inimgrCbSeekCur( InimgrCallbackParams *params, SceOff offset );
int inimgrCbSeekEnd( InimgrCallbackParams *params, SceOff offset );
int inimgrCbTell( InimgrCallbackParams *params );
int inimgrCbWriteln( InimgrCallbackParams *params, char *buf, size_t buflen );
bool inimgrParseEntry( char *entry, char **key, char **value );
int inimgrMakeEntry( char *entry, size_t len, char *key, char *value );
int inimgrMakeSection( char *buf, size_t len, char *section );



#ifdef __cplusplus
}
#endif

#endif
